package com.genesyslab.mobile.android.sample;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;

import android.app.Activity;
import android.os.Bundle;
import android.text.method.ScrollingMovementMethod;
import android.view.View;
import android.widget.TextView;

public class LogActivity extends Activity {

	private String logFile;
	private TextView logTextView;
	
	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.activity_log);
		logFile = getCacheDir().getAbsolutePath() + File.separator + "log";
		logTextView = (TextView)findViewById(R.id.logTextView);
		logTextView.setMovementMethod(new ScrollingMovementMethod());
	}
	
	@Override
	protected void onResume() {
		super.onResume();
		restoreLogTextView();
	}

	private void restoreLogTextView() {
		logTextView.setText("");
	    BufferedReader reader;
		try {
			reader = new BufferedReader(new FileReader(logFile));
		    String line = null;
			while ((line = reader.readLine()) != null) {
				logTextView.append(line + "\n");
			}
		} catch (FileNotFoundException e) {
			logTextView.append("Log file not found");
		} catch (IOException e) {
			logTextView.append("Unable to read log file: " + e);
		}
	}
	
	public void onClickClearButton(View view) {
		try {
			OutputStream out = new FileOutputStream(logFile);
			out.write(new byte[0]);
			out.close();
			restoreLogTextView();
		} catch (IOException e) {
			logTextView.append("Log file not cleared");
		}
	}

}
